@extends('layouts.app')

@section('content')

<section class="right-sidebar" id="sidebarRight">
        <div class="add-track-main-section">
            <div class="add-track-section">
                <div class="addTrack-top">
                    <button class="btn add-single" data-bs-toggle="modal" data-bs-target="#addSingle"><i class="fa-solid fa-plus"></i>Add Single Track</button>

                    <div class="modal fade add-single-track" id="addSingle"  data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
                        <div class="modal-dialog">
                          <div class="modal-content">
                            <div class="modal-header">
                              <h5 class="modal-title" id="staticBackdropLabel">Add Single Track</h5>
                              <button type="button" class="btn-close" data-bs-dismiss="modal"><i class="fa-solid fa-xmark"></i></button>
                            </div>

                            <form class="form-addSingle" method="post" action="{{ route('release.track.save',$release->id) }}" enctype="multipart/form-data" >


                            @csrf

                            <div class="modal-body">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group single-artist">
                                                <label class="form-label" for="artistSingle">Artist</label>

                                                <select name="artists" id="artists" class="form-control" required>
                                                <option value="">Select Artist</option>
                                                @foreach($artists as $artist)
                                                <option value="{{ $artist->id }}" 
                                                @if($artist->id==$release->artists) selected @endif>{{ ucfirst($artist->name) }}</option>
                                                @endforeach
                                            </select>


                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group single-artist">
                                                <label class="form-label" for="displayArtist">Display Artist</label>
                                                <input type="text" class="form-control" name="display_artist" id="display-artist" value="{{ $release->display_artist ?? '' }}" />
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group single-artist">
                                                <label class="form-label" for="featuredArtist">Featured Artist</label>
                                                <input type="text" class="form-control" name="feature_artist" placeholder="Featured Artist" id="feature_artist" value="{{ $release->feature_artist ?? '' }}" />
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group single-artist">
                                                <label class="form-label" for="artistTitle">Title</label>
                                                <input type="text" class="form-control" name="title" id="Release-Title" required value="{{ $release->title ?? '' }}">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group single-artist">
                                                <label class="form-label" for="mainGenre">Main Genre</label>
                                                <select name="genre_id" id="genre_id" class="form-control" required>
                                                <option value="">Select Genre</option>
                                                @foreach($genres as $genre)
                                                <option value="{{ $genre->id }}" @if($release->genre_id==$genre->id) selected @endif >{{ ucfirst($genre->title) }}</option>
                                                @endforeach
                                                </select>

                                            </div>
                                        </div>


                                        <div class="col-md-6" id="tracksubgenredata">
                                            <div class="form-group single-artist">
                                                <label class="form-label" for="subGenre">Sub Genre</label>
                                                <select name="subgenre_id" id="subgenre_id" class="form-control">
                                                <option value="">Select Sub Genre</option>

                                                @php
                                                $subgenres = App\Models\SubGenre::where('genre_id',$release->genre_id)->get();
                                                @endphp

                                                @foreach($subgenres as $subgenre)
                                                <option value="{{ $subgenre->id }}" @if($release->subgenre_id == $subgenre->id) selected @endif>{{ $subgenre->title }}</option>
                                                @endforeach

                                            </select>
                                            </div>
                                        </div>


                                        <div class="col-md-6">
                                            <div class="form-group single-artist">
                                                <label class="form-label" for="disk">Disk</label>
                                                <input class="form-control" name="disc" type="text" id="disk" >
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="form-group single-artist">
                                                <label class="form-label" for="track">Track#</label>
                                                <input class="form-control" name="serial_number" type="text" id="serial_number" >
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="form-group single-artist">
                                                <label class="form-label" for="arranger">Arranger</label>
                                                <input class="form-control" type="text" id="arranger" value="{{ $release->arranger }}" name="arranger" />
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group single-artist">
                                                <label class="form-label" for="actor">Actor</label>
                                                <input class="form-control" type="text" id="actor" value="{{ $release->actor }}" name="actor" >
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group single-artist">
                                                <label class="form-label" for="coductor">Conductor</label>
                                                <input class="form-control" type="text" id="conductor" value="{{ $release->conductor }}" name="conductor" />
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group single-artist">
                                                <label class="form-label" for="composer">Composer</label>
                                                <input class="form-control" type="text" id="composer" value="{{ $release->composer }}" name="composer" />
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group single-artist">
                                                <label class="form-label" for="mixVersion">Mix Version</label>
                                                <input class="form-control" type="text" id="mix_version" name="mix_version" />
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group single-artist">
                                                <label class="form-label" for="chooseRemixer">Choose Remixer</label>
                                                <select name="remixer" id="remixer" class="form-control" >
                                                <option value="">Select Remixer</option>
                                                @foreach(getTrackRemixers() as $remixer)
                                                <option value="{{ $remixer }}">{{ $remixer }}</option>
                                                @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group single-artist">
                                                <label class="form-label" for="orEnter">Or Enter Remixer(s)</label>
                                                <input class="form-control" type="text" id="remixer_list" name="remixer_list[]" />
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="form-group single-artist">
                                                <label class="form-label" for="orchestra">Orchestra</label>
                                                <input class="form-control" type="text" id="orchestra" value="{{ $release->orchestra }}" name="orchestra" />
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group single-artist">
                                                <label class="form-label" for="publisher">Publisher</label>
                                                <input class="form-control" type="text" id="publisher" name="publisher" />
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group single-artist">
                                                <label class="form-label" for="contributors">Contributors</label>
                                                <input class="form-control" type="text" id="contributors" name="contributors" />
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="form-group single-artist">
                                                <label class="form-label" for="priceTires">Price Tires (For iTunes Only)</label>

                                                <select name="price_tier" id="price_tier" class="form-control">
                                                <option value="">Select Price Tier</option>
                                                @foreach(release_prices_tires() as $price_key => $price_val)
                                                    <option value="{{ $price_key}}" @if($release->price_tier == $price_key) selected @endif>
                                                        {{ $price_val }}
                                                    </option>
                                                @endforeach

                                            </div>
                                        </div>

                        
                                 


                                        <div class="col-md-6">
                                            <div class="form-group single-artist">
                                                <label class="form-label" for="priceTires">Audio File (Must be Wav - 44.1khz)</label>
                                                <input class="form-control custom-file-input" type="file" id="priceTires" accept=".wav" >
                                            </div>
                                        </div>



                                        <div class="col-md-6">
                                            <div class="form-group single-artist">
                                                <label class="form-label" for="priceTires">Do you have ISRC?</label>
                                                <div class="main-form-radio d-flex justify-content-start gap-3">
                                                    <div class="radio-btn">
                                                        <input type="radio" class="form-check-input me-1" name="have_isrc" id="yes" checked value="1" />
                                                        <label class="form-check-label" for="yes">Yes</label>
                                                    </div>
                                                    <div class="radio-btn">
                                                        <input type="radio" class="form-check-input me-1" name="have_isrc" id="no" value="0" />
                                                        <label class="form-check-label" for="no">No</label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-12">
                                            <div class="form-check-main">
                                                <div class="form-check single-artist-check">
                                                    <input class="form-check-input" type="checkbox" id="explicit"  name="explicit" value="1" >
                                                    <label class="form-check-label" for="orEnter">Explicit</label>
                                                </div>
                                                <div class="form-check single-artist-check">
                                                    <input class="form-check-input" type="checkbox" id="sold_with_album"  name="sold_with_album" value="1">
                                            
                                                    <label class="form-check-label" for="orEnter">Yes, this track can be sold with full album</label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                               
                            </div>
                            <div class="modal-footer">
                              <button type="submit" class="btn add-single-btn">Save</button>
                            </div>

                            </form>

                          </div>
                        </div>
                    </div>

                    <button class="btn add-multiple" data-bs-toggle="modal" data-bs-target="#addMultiple"><i class="fa-solid fa-plus"></i>Add Multiple Track</button>

                    <div class="modal fade add-multiple-track" id="addMultiple"  data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
                        <div class="modal-dialog">
                          <div class="modal-content">
                            <div class="modal-header">
                              <h5 class="modal-title" id="staticBackdropLabel">Add Multiple Track</h5>
                              <button type="button" class="btn-close" data-bs-dismiss="modal"><i class="fa-solid fa-xmark"></i></button>
                            </div>
                            <div class="modal-body">
                                <div class="add-multiple-track-box">
                                    <div class="chose-mainbox">
                                        <div class="file-icon">
                                            <i class="fa-solid fa-plus"></i>
                                        </div>
                                        <div class="chose-file-content">
                                            <h5>Choose file for Art Work</h5>
                                        </div>
                                    </div>
                                </div>
                            </div>
                          </div>
                        </div>
                    </div>
                </div>
             @include('releases.tracks')
            </div>
        </div>
    </section>

<script>
    $("#genre_id").change(function() {
        var genre_id = $(this).val();
        $.ajax({
            url: "{{ route('release.subgenre') }}",
            type: "POST",
            data: {
                'genre_id': genre_id,
                'track' : true,
                "_token": "{{ csrf_token() }}"
            },
            cache: false,
            success: function(html) {
                $("#tracksubgenredata").html(html);
            },
            error: function(textStatus, errorThrown) {
                alert('Something went wrong!');
                return false;
            }
        });
    });


    </script>






    {{--
    <div class="row">
        <div class="col-lg-12 margin-tb">
            <div class="pull-left">
                <h2>Update New Release</h2>
            </div>
            <div class="pull-right">
                <a class="btn btn-primary btn-sm mb-2" href="{{ route('release.index') }}"><i class="fa fa-arrow-left"></i> Back</a>
            </div>
        </div>
    </div>
    <?php

    use Illuminate\Support\Facades\Session;

    $active = null;
    $step = null;
    if (Session::has('release_step')) {
        $step = Session::get('release_step');
    } else {
        $active = "active";
    }
    ?>

    <ul class="nav nav-tabs" role="tablist">

        <li class="nav-item">
            <a class="nav-link @if(empty($step)) active @endif" data-bs-toggle="tab" href="#releasetab">Release</a>
        </li>

        <li class="nav-item">
            <a class="nav-link @if(!empty($step)) active @endif"
                @if(!empty($step) && 2 <=$step) data-bs-toggle="tab" @endif href="#audiofiles">Audio Files</a>
        </li>

        <li class="nav-item">
            <a class="nav-link"
                @if(!empty($step) && 3 <=$step) data-bs-toggle="tab" @endif href="#splits">Splits</a>
        </li>

        <li class="nav-item">
            <a class="nav-link"
                @if(!empty($step) && 4 <=$step ) data-bs-toggle="tab" @endif href="#territories">Territories</a>
        </li>

        <li class="nav-item">
            <a class="nav-link"
                @if(!empty($step) && 5 <=$step ) data-bs-toggle="tab" @endif href="#deliveries">Deliveries</a>
        </li>

        <li class="nav-item">
            <a class="nav-link"
                @if(!empty($step) && 6 <=$step) data-bs-toggle="tab" @endif href="#finish">Finish</a>
        </li>


    </ul>

    @if (count($errors) > 0)
    <div class="alert alert-danger">
        <label>Whoops!</label> There were some problems with your input.<br><br>
        <ul>
            @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
    @endif

    <!-- release  panel -->
    <div class="tab-content">
    <div id="releasetab" class="container tab-pane @if(empty($step)) active @endif"><br>
        <form action="{{ route('release.update', $release->id) }}" method="post" id="frmReleaseStep1" enctype="multipart/form-data">
            @csrf
            @method('PUT')
            <div class="row">
                <div class="col-xs-12 col-sm-12 col-md-12 d-flex">
                    <a href="javascript:void(0);">
                        <button class="btn btn-success" type="button">Luminate ISRC Registration</button>
                    </a>&nbsp;&nbsp;

                    <a href="javascript:void(0);">
                        <button class="btn btn-success" type="button">Luminate Title Registration</button>
                    </a>
                </div>


                <div class="col-xs-6 col-sm-6 col-md-6">
                    <div class="form-group">
                        <label>Language:</label>
                        <input type="text" name="lang" class="form-control" value="{{ $release->lang }}" />
                    </div>
                </div>

                <div class="col-xs-6 col-sm-6 col-md-6">
                    <div class="form-group">
                        <label class="required">Choose Primary Artist:</label>
                        <select name="artists" id="artists" class="form-control" required>
                            <option value="">Select Artist</option>
                            @foreach($artists as $artist)
                            <option value="{{ $artist->id }}" @if($release->artists == $artist->id) selected @endif>{{ ucfirst($artist->name) }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>


                <div class="col-xs-6 col-sm-6 col-md-6">
                    <div class="form-group">
                        <label>Display Artist:</label>
                        <input type="text" name="display_artist" class="form-control" value="{{ $release->display_artist }}" />
                    </div>
                </div>

                <div class="col-xs-6 col-sm-6 col-md-6">
                    <div class="form-group">
                        <label>Featured Artist:</label>
                        <input type="text" name="feature_artist" class="form-control" value="{{ $release->feature_artist }}" />
                    </div>
                </div>


                <div class="col-xs-6 col-sm-6 col-md-6">
                    <div class="form-group">
                        <label>Remixer:</label>
                        <input type="text" name="remixer" class="form-control" value="{{ $release->remixer }}" />
                    </div>
                </div>


                <div class="col-xs-6 col-sm-6 col-md-6">
                    <div class="form-group">
                        <label class="required">Composer:</label>
                        <input type="text" name="composer" class="form-control" required value="{{ $release->composer }}" />
                    </div>
                </div>


                <div class="col-xs-6 col-sm-6 col-md-6">
                    <div class="form-group">
                        <label>Orchestra:</label>
                        <input type="text" name="orchestra" class="form-control" value="{{ $release->orchestra }}" />
                    </div>
                </div>

                <div class="col-xs-6 col-sm-6 col-md-6">
                    <div class="form-group">
                        <label>Arranger:</label>
                        <input type="text" name="arranger" class="form-control" value="{{ $release->arranger }}" />
                    </div>
                </div>

                <div class="col-xs-6 col-sm-6 col-md-6">
                    <div class="form-group">
                        <label>Actor:</label>
                        <input type="text" name="actor" class="form-control" value="{{ $release->actor }}" />
                    </div>
                </div>


                <div class="col-xs-6 col-sm-6 col-md-6">
                    <div class="form-group">
                        <label>Conductor:</label>
                        <input type="text" name="conductor" class="form-control" value="{{ $release->conductor }}" />
                    </div>
                </div>


                <h5 class="required">Is Instrumental?</h5>
                <div class="col-xs-6 col-sm-6 col-md-6 d-flex">

                    <div class="form-group">
                        <input type="radio" name="is_instrumental" value="1" class="form-check-input" @if($release->is_instrumental == 1) selected @endif />
                        <label>Yes:</label>
                    </div>

                    <div class="form-group">
                        <input type="radio" checked name="is_instrumental" value="0" class="form-check-input" @if($release->is_instrumental == 0) selected @endif />
                        <label>No:</label>
                    </div>
                </div>

                <div class="col-xs-6 col-sm-6 col-md-6" id="lyricistData">
                    <div class="form-group d-flex">
                        <label>Lyricist:</label>
                        <input type="text" name="lyricist_firstname" placeholder="First Name" class="form-control" value="{{ $release->lyricist_firstname }}" />
                        <input type="text" name="lyricist_lastname" placeholder="Last Name" class="form-control" value="{{ $release->lyricist_lastname }}" />
                    </div>
                </div>


                <div class="col-xs-6 col-sm-6 col-md-6">
                    <div class="form-group">
                        <label class="required">Release Title:</label>
                        <input type="text" name="title" class="form-control" required value="{{ $release->title }}" />
                    </div>
                </div>

                <div class="col-xs-6 col-sm-6 col-md-6">
                    <div class="form-group">
                        <label>Label:</label>
                        <select name="label_id" id="label_id" class="form-control">
                            <option value="">Select Label</option>
                            @foreach($users as $user)
                            <option value="{{ $user->id }}" @if($release->label_id == $user->id) selected @endif >{{ ucfirst($user->name) }}</option>
                            @endforeach
                        </select>
                        <a href="{{ route('users.create') }}?release=editRelease&releaseid={{ $release->id }}"><button class="btn btn-success" type="button">Add Lable</button></a>
                    </div>
                </div>


                <div class="col-xs-6 col-sm-6 col-md-6">
                    <div class="form-group">
                        <label class="required">ArtWork:</label>
                        <input type="file" name="artwork" class="form-control" />
                    </div>
                </div>


                <div class="col-xs-6 col-sm-6 col-md-6">
                    <div class="form-group">
                        <label class="required">Motion Art for apple:</label>
                        <input type="file" name="apple_art" class="form-control" />
                    </div>
                </div>


                <h5>Release Type</h5>
                <div class="col-xs-6 col-sm-6 col-md-6 d-flex">
                    <div class="form-group">
                        <input type="radio" checked name="release_type" value="release" class="form-check-input" @if($release->release_type == "release") selected @endif />
                        <label>Release:</label>
                    </div>

                    <div class="form-group">
                        <input type="radio" name="release_type" value="album" class="form-check-input" @if($release->release_type == "album") selected @endif />
                        <label>Album:</label>
                    </div>

                    <div class="form-group">
                        <input type="radio" name="release_type" value="mix" class="form-check-input" @if($release->release_type == "mix") selected @endif />
                        <label>Mix:</label>
                    </div>
                </div>

                <div class="col-xs-6 col-sm-6 col-md-6">
                    <div class="form-group">
                        <label class="required">Catalog Number:</label>
                        <input type="text" name="cat_number" class="form-control" required value="{{ $release->cat_number }}" />
                    </div>
                </div>

                <div class="col-xs-6 col-sm-6 col-md-6">
                    <div class="form-group">
                        <label>Main Genre:</label>
                        <select name="genre_id" id="genre_id" class="form-control">
                            <option value="">Select Genre</option>
                            @foreach($genres as $genre)
                            <option value="{{ $genre->id }}" @if($release->genre_id == $genre->id) selected @endif >{{ ucfirst($genre->title) }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>


                <div class="col-xs-6 col-sm-6 col-md-6" id="subgenredata">
                    <div class="form-group">
                        <label>Sub Genre:</label>
                        <select name="subgenre_id" id="subgenre_id" class="form-control">
                            <option value="">Select Sub Genre</option>
                            @php
                            $subgenres = App\Models\SubGenre::where('genre_id',$release->genre_id)->get();
                            @endphp

                            @foreach($subgenres as $subgenre)
                            <option value="{{ $subgenre->id }}" @if($release->subgenre_id == $subgenre->id) selected @endif>{{ $subgenre->title }}</option>
                            @endforeach

                        </select>
                    </div>
                </div>

                <h5>Do you have UPC</h5>

                <div class="col-xs-6 col-sm-6 col-md-6 d-flex">
                    <div class="form-group">
                        <input type="radio" @if($release->is_upc == 1) checked @endif name="is_upc" value="1" class="form-check-input"/>
                        <label>Yes:</label>
                    </div>


                    <div class="form-group">
                        <input type="radio" name="is_upc" value="0" class="form-check-input" @if($release->is_upc == 0) checked @endif />
                        <label>No:</label>
                    </div>
                </div>


                <div class="col-xs-6 col-sm-6 col-md-6" id="upcnumberData">
                    <div class="form-group d-flex">
                        <label>UPC/EAN:</label>
                        <input type="text" name="upc_number" class="form-control" value="{{ $release->upc_number }}" />
                    </div>
                </div>


                <div class="col-xs-6 col-sm-6 col-md-6">
                    <div class="form-group">
                        <label class="required">Release Date:</label>
                        <input type="datetime-local" name="release_date" class="form-control" required value="{{ $release->release_date }}" />
                    </div>
                </div>


                <div class="col-xs-6 col-sm-6 col-md-6">
                    <div class="form-group">
                        <label class="required">P Line:</label>
                        <input type="text" name="p_line" placeholder="P-Line" class="form-control" required value="{{ $release->p_line }}" />
                    </div>
                </div>

                <div class="col-xs-6 col-sm-6 col-md-6">
                    <div class="form-group">
                        <label class="required">C Line:</label>
                        <input type="text" name="c_line" placeholder="C-Line" class="form-control" required value="{{ $release->c_line }}" />
                    </div>
                </div>

                <div class="col-xs-6 col-sm-6 col-md-6">
                    <div class="form-group">
                        <label>Copyrights:</label>
                        <input type="text" name="copyrights" placeholder="Copyrights" class="form-control" value="{{ $release->copyrights }}" />
                    </div>
                </div>


                <div class="col-xs-6 col-sm-6 col-md-6">
                    <div class="form-group">
                        <label>Price Tiers(For ITunes Only):</label>
                        <select name="price_tier" id="price_tier" class="form-control">
                            <option value="">Select Price Tier</option>

                            @foreach(release_prices_tires() as $price_key => $price_val)
                            <option value="{{ $price_key}}" @if($release->price_tier == $price_key) selected @endif>
                                {{ $price_val }}
                            </option>
                            @endforeach

                        </select>
                    </div>
                </div>

                <div class="col-xs-6 col-sm-6 col-md-6">
                    <div class="form-group">
                        <label>Parental Warning Types:</label>
                        <select name="parental_warning_type" id="parental_warning_type" class="form-control">

                            <option value="NotExplicit" @if($release->parental_warning_type == "NotExplicit") selected @endif>NotExplicit</option>

                            <option value="Explicit" @if($release->parental_warning_type == "Explicit") selected @endif>Explicit</option>

                            <option value="ExplicitContentEdited" @if($release->parental_warning_type == "ExplicitContentEdited") selected @endif>ExplicitContentEdited</option>

                        </select>
                    </div>
                </div>

                <div class="col-xs-12 col-sm-12 col-md-12">
                    <div class="form-group">
                        <label>Release Description:</label>
                        <textarea style="height: 131px;" name="description" id="description" class="form-control">{{ $release->description }}</textarea>
                    </div>
                </div>


                <div class="col-xs-12 col-sm-12 col-md-12">
                    <button type="submit" class="btn btn-primary btn-sm mt-2 mb-3"><i class="fa-solid fa-floppy-disk"></i> Next</button>
                </div>

            </div>
        </form>
    </div>


    <!-- Audio file panel -->
    <div id="audiofiles" class="container tab-pane @if(!empty($step)) active @endif"><br>
        @include('releases.tracks')
        @include('releases.create_track')
    </div>

    <!-- splits -->
    <div id="splits" class="container tab-pane"><br>
        @include('releases.splits')
    </div>

    <!-- territories -->
    <div id="territories" class="container tab-pane"><br>
        @include('releases.territories')
    </div>


    <!-- deliveries -->
    <div id="deliveries" class="container tab-pane"><br>
        @include('releases.deliveries')
    </div>


    <!-- Finish -->
    <div id="finish" class="container tab-pane"><br>

        <form action="{{ route('release.finish.save', $release->id) }}" method="post" id="frmReleaseStepFinish" enctype="multipart/form-data">
            @csrf
            <div class="row">
                <h5>SET ADDITION OPTIONS</h5>
                <div class="col-xs-6 col-sm-6 col-md-6">
                    <div class="form-group">
                        <label>Exclusive on shop:</label>
                        <select name="exclusive_on_shop" id="exclusive_on_shop" class="form-control">
                            <option value="">Select Shop</option>
                            @foreach($dsps as $dsp)
                            <option value="{{ $dsp->id }}" @if($release->exclusive_on_shop == $dsp->id) selected @endif>
                                {{ $dsp->name }}
                            </option>
                            @endforeach
                        </select>
                    </div>
                </div>

                <div class="col-xs-6 col-sm-6 col-md-6">
                    <div class="form-group">
                        <label>Exclusive for:</label>
                        <select name="exclusive_for" id="exclusive_for" class="form-control">
                            <option value="2 weeks" @if($release->exclusive_for == "2 weeks") selected @endif>
                                2 Weeks
                            </option>
                            <option value="4 weeks" @if($release->exclusive_for == "4 weeks") selected @endif>
                                4 Weeks
                            </option>
                            <option value="8 weeks" @if($release->exclusive_for == "8 weeks") selected @endif>
                                8 Weeks
                            </option>
                            <option value="lifetime" @if($release->exclusive_for == "lifetime") selected @endif>
                                lifetime
                            </option>
                        </select>
                    </div>
                </div>

                <div class="col-xs-12 col-sm-12 col-md-12">
                    <div class="form-group d-flex">
                        <input type="checkbox" name="on_itunes" value="1" class="form-check-input" @if($release->on_itunes == 1) checked @endif />
                        <p>Yes,allow pre-orders on ITunes:</p>
                    </div>

                    <div class="form-group d-flex">
                        <input type="checkbox" name="agree" value="0" class="form-check-input" required />
                        <p>PLEASE REVIEW ALL DETAILS BELOW TO ENSURE YOUR RELEASE IS 100% CORRECT! After your release have been submitted it is very difficult to correct any error as there is no guarantee that our partners will be able to fix or take down a release if an issue is reported. Fee may also be involed. By submitting this release you agree to the terms and conditions listed at the bottom of this page.</p>
                    </div>
                </div>

                <div class="col-xs-12 col-sm-12 col-md-12">
                    <button type="submit" class="btn btn-primary btn-sm mt-2 mb-3"><i class="fa-solid fa-floppy-disk"></i> Save</button>
                </div>

            </div>
        </form>

    </div>

    <script type="text/javascript">
        $(document).ready(function() {
            $("#frmReleaseStep1").validate({
                rules: {
                    artists: {
                        required: true
                    },
                    is_instrumental: {
                        required: true
                    },
                    title: {
                        required: true
                    },

                    cat_number: {
                        required: true
                    },

                    p_line: {
                        required: true
                    },

                    c_line: {
                        required: true
                    },

                    composer: {
                        required: true
                    },
                },
                messages: {
                    artists: {
                        required: "Artists field is required"
                    },
                    is_instrumental: {
                        required: "Is Instrument field is required"
                    },
                    title: {
                        required: "Title field is required"
                    },
                    cat_number: {
                        required: "Catalog Number field is required"
                    },
                    p_line: {
                        required: "P Line field is required"
                    },

                    c_line: {
                        required: "C Line field is required"
                    },

                    composer: {
                        required: "Composer field is required"
                    },
                }
            });

            $("#frmReleaseStepFinish").validate({
                rules: {
                    agree: {
                        required: true
                    },
                },
                messages: {
                    agree: {
                        required: "Please accept terms and conditions."
                    },
                }
            });




        });


        $(document).ready(function() {
            $("input:radio[name=is_instrumental]").click(function() {
                if ($('input:radio[name=is_instrumental]:checked').val() == "0") {
                    $('#lyricistData').show();
                }
                if ($('input:radio[name=is_instrumental]:checked').val() == "1") {
                    $('#lyricistData').hide();
                }
            });
        });


        $(document).ready(function() {
            $("input:radio[name=have_isrc]").click(function() {
                if ($('input:radio[name=have_isrc]:checked').val() == "0") {
                    $('#isrc_main_div').hide();
                }
                if ($('input:radio[name=have_isrc]:checked').val() == "1") {
                    $('#isrc_main_div').show();
                }
            });
        });


        $(document).ready(function() {
            $("input:radio[name=is_upc]").click(function() {
                if ($('input:radio[name=is_upc]:checked').val() == "1") {
                    $('#upcnumberData').show();
                }
                if ($('input:radio[name=is_upc]:checked').val() == "0") {
                    $('#upcnumberData').hide();
                }
            });
        });


        $(document).ready(function() {
            $("#genre_id").change(function() {
                var genre_id = $(this).val();
                $.ajax({
                    url: "{{ route('release.subgenre') }}",
                    type: "POST",
                    data: {
                        'genre_id': genre_id,
                        "_token": "{{ csrf_token() }}"
                    },
                    cache: false,
                    success: function(html) {
                        $("#subgenredata").html(html);
                    },
                    error: function(textStatus, errorThrown) {
                        alert('Something went wrong!');
                        return false;
                    }
                });
            });
        });

        $(document).on("click", '#addremixerbutton', function(event) {
            var addremixer = `<div class="form-group">
                <input type="text" name="remixer_list[]" class="form-control" />
            </div>`;
            $('#remixerData').append(addremixer);
        });
    </script>
    --}}
    
    @endsection